<Query Kind="Program">
  <Namespace>System.Net</Namespace>
  <Namespace>System.Net.Mail</Namespace>
  <Namespace>System.Net.Sockets</Namespace>
  <Namespace>System.Threading.Tasks</Namespace>
</Query>

void Main()
{
	using (TcpClient client = new TcpClient ("mail.isp.com", 110))
	using (NetworkStream n = client.GetStream())
	{
		ReadLine (n);                             // wczytanie wiadomości powitalnej
		SendCommand (n, "USER username");
		SendCommand (n, "PASS password");
		SendCommand (n, "LIST");                  // pobranie identyfikatorów wiadomości
		List<int> messageIDs = new List<int>();
		while (true)
		{
			string line = ReadLine (n);             // np.  "1 1876"
			if (line == ".") break;
			messageIDs.Add (int.Parse (line.Split (' ') [0]));   // identyfikator wiadomości
		}

		foreach (int id in messageIDs)         // pobranie wszystkich wiadomości
		{
			SendCommand (n, "RETR " + id);
			string randomFile = Guid.NewGuid().ToString() + ".eml";
			using (StreamWriter writer = File.CreateText (randomFile))
				while (true)
				{
					string line = ReadLine (n);      // wczytanie następnego wiersza wiadomości
					if (line == ".") break;          // jedna kropka = koniec wiadomości
					if (line == "..") line = ".";    // dwie kropki oznaczają „ucieczkę”
					writer.WriteLine (line);         // zapis do pliku wyjściowego
				}
			SendCommand (n, "DELE " + id);       // usunięcie wiadomości z serwera
		}
		SendCommand (n, "QUIT");
	}

}

static string ReadLine (Stream s)
{
	List<byte> lineBuffer = new List<byte>();
	while (true)
	{
		int b = s.ReadByte();
		if (b == 10 || b < 0) break;
		if (b != 13) lineBuffer.Add ((byte)b);
	}
	return Encoding.UTF8.GetString (lineBuffer.ToArray());
}

static void SendCommand (Stream stream, string line)
{
	byte[] data = Encoding.UTF8.GetBytes (line + "\r\n");
	stream.Write (data, 0, data.Length);
	string response = ReadLine (stream);
	if (!response.StartsWith ("+OK"))
		throw new Exception ("Błąd POP: " + response);
}